<?php
/**
T4 Overide
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use T4\Helper\J3J4;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');

// Create shortcuts to some parameters.
$params  = $this->item->params;
$images  = json_decode($this->item->images);
$urls    = json_decode($this->item->urls);
$canEdit = $params->get('access-edit');
$user    = Factory::getUser();
$info    = $params->get('info_block_position', 0);

// Check if associations are implemented. If they are, define the parameter.
$assocParam = (Associations::isEnabled() && $params->get('show_associations'));

if(version_compare(JVERSION, '4', 'ge')){
	$currentDate       = Factory::getDate()->format('Y-m-d H:i:s');
	$isExpired         = !is_null($this->item->publish_down) && $this->item->publish_down < $currentDate;
	$isNotPublishedYet = $this->item->publish_up > $currentDate;
	$isUnpublished     = $this->item->state == ContentComponent::CONDITION_UNPUBLISHED || $isNotPublishedYet || $isExpired;
}else{
	$isExpired         = (strtotime($this->item->publish_down) < strtotime(Factory::getDate())) && $this->item->publish_down != Factory::getDbo()->getNullDate();
	$isNotPublishedYet = strtotime($this->item->publish_up) > strtotime(Factory::getDate());
	$isUnpublished     = J3J4::checkUnpublishedContent($this->item);
}

// Custom field
$extrafields = new JRegistry($this->item->attribs);

$longDesc = $extrafields->get('long-desc');
$client = $extrafields->get('client');
$day = $extrafields->get('day');
$type = $extrafields->get('type');
$link = $extrafields->get('link');
$rating = $extrafields->get('rating');

$pfTask = $extrafields->get('portfolio-task');
$pftGallery = $extrafields->get('portfolio-gallery');
$titleGallery = $extrafields->get('gallery-title');
$descGallery = $extrafields->get('gallery-desc');


?>
<div class="com-content-article view-portfolio-detail item-page<?php echo $this->pageclass_sfx; ?>" itemscope itemtype="https://schema.org/Article">
	<meta itemprop="inLanguage" content="<?php echo ($this->item->language === '*') ? Factory::getApplication()->get('language') : $this->item->language; ?>">

	<div class="row">
		<div class="col-lg-6">
			<?php if ($this->params->get('show_page_heading')) : ?>
			<div class="page-header">
				<h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
			</div>
			<?php endif; ?>

			<?php // Todo Not that elegant would be nice to group the params ?>
			<?php $useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
			|| $params->get('show_hits') || $params->get('show_parent_category') || $params->get('show_author') || $assocParam); ?>

			<?php if (!$useDefList && $this->print) : ?>
				<div id="pop-print" class="btn hidden-print clearfix">
					<?php echo HTMLHelper::_('icon.print_screen', $this->item, $params); ?>
				</div>
			<?php endif; ?>

			<?php if ($params->get('show_title') || $params->get('show_author')) : ?>
			<div class="page-header">
				<?php if ($params->get('show_title')) : ?>
					<h2 itemprop="headline">
						<?php echo $this->escape($this->item->title); ?>
					</h2>
				<?php endif; ?>

				<?php if ($isUnpublished) : ?>
					<span class="label label-warning"><?php echo Text::_('JUNPUBLISHED'); ?></span>
				<?php endif; ?>

				<?php if ($isNotPublishedYet) : ?>
					<span class="badge badge-warning"><?php echo Text::_('JNOTPUBLISHEDYET'); ?></span>
				<?php endif; ?>

				<?php if ($isExpired) : ?>
					<span class="badge badge-warning"><?php echo Text::_('JEXPIRED'); ?></span>
				<?php endif; ?>

			</div>
			<?php endif; ?>

			<?php if (!$this->print) : ?>
				<?php if ($canEdit || $params->get('show_print_icon') || $params->get('show_email_icon')) : ?>
					<?php echo LayoutHelper::render('joomla.content.icons', array('params' => $params, 'item' => $this->item, 'print' => false)); ?>
				<?php endif; ?>
			<?php else : ?>
				<?php if ($useDefList) : ?>
					<div id="pop-print" class="btn hidden-print">
						<?php echo HTMLHelper::_('icon.print_screen', $this->item, $params); ?>
					</div>
				<?php endif; ?>
			<?php endif; ?>

			<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
			<?php echo $this->item->event->afterDisplayTitle; ?>

			<?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
				<?php echo LayoutHelper::render('joomla.content.info_block', array('item' => $this->item, 'params' => $params, 'position' => 'above')); ?>
			<?php endif; ?>

			<?php if ($info == 0 && $params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
				<?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>
				<?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
			<?php endif; ?>
		</div>

		<?php if($longDesc) :?>
		<div class="col-lg-6">
			<div class="long-desc">
				<?php echo $longDesc ;?>
			</div>
		</div>
		<?php endif ;?>
	</div>

	<?php if(!empty($pfTask)) :?>
  	<ul class="task-wrap row">
  		<?php $i=0; foreach ($pfTask as $key=>$value) : $i++; ?>
				<li class="col-12 col-sm-6 col-lg-auto flex-lg-fill mb-3 mb-lg-0">
					<span class="text-primary h2"><?php echo $value->task_title; ?></span>
					<span class="task-title"><?php echo $value->task_label; ?></span>
				</li>
			<?php endforeach ;?>
  	</ul>
  <?php endif ;?>
	
	<div class="info-task-wrap row">
		<?php if ($params->get('access-view')) : ?>
		<div class="col-lg-8">
				<?php echo LayoutHelper::render('joomla.content.full_image', $this->item); ?>
		</div>
		<?php endif ;?>

		<div class="col-lg-4">
			<ul class="bg-primary-light info-detail">
				<?php if($params->get('show_category')) :?>
					<li>
						<label><?php echo Jtext::_('TPL_CATEGORY') ;?>:</label>
			    	<?php echo LayoutHelper::render('joomla.content.info_block.category', array('item' => $this->item, 'params' => $params)); ?>
			    </li>
			  <?php endif;?>

			  <?php if($client) :?>
					<li><label><?php echo Jtext::_('TPL_CLIENT') ;?>:</label><?php echo $client ;?></li>
				<?php endif ;?>

				<?php if($day) :?>
					<li><label><?php echo Jtext::_('TPL_DAY') ;?>:</label><?php echo $day ;?></li>
				<?php endif ;?>

				<?php if($type) :?>
					<li><label><?php echo Jtext::_('TPL_TYPE') ;?>:</label><?php echo $type ;?></li>
				<?php endif ;?>

				<?php if($link) :?>
					<li><label><?php echo Jtext::_('TPL_LINK') ;?>:</label>
						<a href="<?php echo $link ;?>" title=""><?php echo $link ;?></a>
					</li>
				<?php endif ;?>

				<?php if($rating) :?>
					<li><label><?php echo Jtext::_('TPL_RATE') ;?>:</label>
						<span class="portfolio-rating">
							<span class="stars-vote" style="width: <?php echo $rating ?>%"></span>
						</span>
					</li>
				<?php endif ;?>
			</ul>
		</div>
	</div>

	

	

	<?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
	<?php echo $this->item->event->beforeDisplayContent; ?>

	<?php if (isset($urls) && ((!empty($urls->urls_position) && ($urls->urls_position == '0')) || ($params->get('urls_position') == '0' && empty($urls->urls_position)))
		|| (empty($urls->urls_position) && (!$params->get('urls_position')))) : ?>
		<?php echo $this->loadTemplate('links'); ?>
	<?php endif; ?>

	<?php if ($params->get('access-view')) : ?>
		
		<?php if (!empty($this->item->pagination) && $this->item->pagination && !$this->item->paginationposition && !$this->item->paginationrelative) :
			echo $this->item->pagination;
		endif; ?>

	<?php if (isset ($this->item->toc)) : echo $this->item->toc; endif; ?>

	<div itemprop="articleBody" class="com-content-article__body">
		<?php echo $this->item->text; ?>
	</div>

	<?php if(!empty($pftGallery)) :?>
  	<ul class="gallery-wrap row">
  		<?php $i=0; foreach ($pftGallery as $key=>$value) : $i++; ?>
				<li class="col-lg-<?php echo ($i == 4 || $i == 5) ? '6' : '4' ;?>">
					<a href="<?php echo $value->gallery_img; ?>" data-parent=".gallery-wrap"  data-toggle="lightbox" data-gallery="gallery" >
						<img src="<?php echo $value->gallery_img; ?>" alt="<?php echo $value->gallery_alt; ?>" />
					</a>
				</li>

				<?php if($i == 5) $i = 0 ;?>
			<?php endforeach ;?>
  	</ul>

  	<?php if($titleGallery || $descGallery) :?>
  	<div class="more-info-gallery">
	  	<?php if($titleGallery) :?>
	  		<h3><?php echo $titleGallery ;?></h3>
	  	<?php endif ;?>

	  	<?php if($descGallery) :?>
	  		<div class="description-gallery"><?php echo $descGallery ;?></div>
	  	<?php endif ;?>
	  </div>
	  <?php endif ;?>
  <?php endif ;?>

	<?php if ($info == 1 || $info == 2) : ?>
		<?php if ($useDefList) : ?>
			<?php echo LayoutHelper::render('joomla.content.info_block', array('item' => $this->item, 'params' => $params, 'position' => 'below')); ?>
		<?php endif; ?>

		<?php if ($params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
			<?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>
			<?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
		<?php endif; ?>
	<?php endif; ?>

	<?php
		if (!empty($this->item->pagination) && $this->item->pagination && $this->item->paginationposition && !$this->item->paginationrelative) :
			echo $this->item->pagination;
		endif;
	?>

	<?php if (isset($urls) && ((!empty($urls->urls_position) && ($urls->urls_position == '1')) || ($params->get('urls_position') == '1'))) : ?>
		<?php echo $this->loadTemplate('links'); ?>
	<?php endif; ?>

	<?php // Optional teaser intro text for guests ?>
	<?php elseif ($params->get('show_noauth') == true && $user->get('guest')) : ?>
		<?php echo LayoutHelper::render('joomla.content.intro_image', $this->item); ?>
		<?php echo HTMLHelper::_('content.prepare', $this->item->introtext); ?>
		<?php // Optional link to let them register to see the whole article. ?>
	
		<?php if ($params->get('show_readmore') && $this->item->fulltext != null) : ?>
		<?php $menu = Factory::getApplication()->getMenu(); ?>
		<?php $active = $menu->getActive(); ?>
		<?php $itemId = $active->id; ?>
		<?php $link = new Uri(Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false)); ?>
		<?php $link->setVar('return', base64_encode(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language))); ?>

		<p class="com-content-article__readmore readmore">
			<a href="<?php echo $link; ?>" class="register">
			<?php $attribs = json_decode($this->item->attribs); ?>
			<?php
			if ($attribs->alternative_readmore == null) :
				echo Text::_('COM_CONTENT_REGISTER_TO_READ_MORE');
			elseif ($readmore = $attribs->alternative_readmore) :
				echo $readmore;
				if ($params->get('show_readmore_title', 0) != 0) :
					echo HTMLHelper::_('string.truncate', $this->item->title, $params->get('readmore_limit'));
				endif;
			elseif ($params->get('show_readmore_title', 0) == 0) :
				echo Text::sprintf('COM_CONTENT_READ_MORE_TITLE');
			else :
				echo Text::_('COM_CONTENT_READ_MORE');
				echo HTMLHelper::_('string.truncate', $this->item->title, $params->get('readmore_limit'));
			endif; ?>
			</a>
		</p>
		<?php endif; ?>
	<?php endif; ?>

	<?php
		if (!empty($this->item->pagination) && $this->item->pagination && $this->item->paginationposition && $this->item->paginationrelative) :
			echo $this->item->pagination;
		endif;
	?>

	<?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
	<?php echo $this->item->event->afterDisplayContent; ?>
</div>

<script>
	(function($){
		// Popup Gallery Images
    if ($('.gallery-wrap').length > 0) {
      $(document).delegate('*[data-toggle="lightbox"]', 'click', function(event) {
        event.preventDefault();
        return $(this).ekkoLightbox();
      }); 
    }
	})(jQuery);
</script>
