<?php
/**
 * @package DJ-Tabs
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email: contact@dj-extensions.com
 */

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Layout\LayoutHelper;
HTMLHelper::_('bootstrap.tooltip');

$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');

$saveOrder = $listOrder == 'a.ordering';
if($saveOrder){
    HTMLHelper::_('sortablelist.sortable', 'itemsList', 'adminForm', strtolower($listDirn), 'index.php?option=com_djtabs&task=groups.saveOrderAjax&tmpl=component');
}

?>
<form action="<?php echo Route::_('index.php?option=com_djtabs&view=groups');?>" method="post" name="adminForm" id="adminForm">
<div class="<?php echo $this->bs_cl->row; ?>">
	<?php if(!empty($this->sidebar)): ?>
	<div id="j-sidebar-container" class="<?php echo $this->bs_cl->col; ?>2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="<?php echo $this->bs_cl->col; ?>10">
	<?php else: ?>
	<div id="j-main-container">
	<?php endif; ?>	

		<?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

		<div class="clearfix"> </div>

		<table class="table table-striped" id="itemsList">
		<thead>
			<tr>	
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" value="" onclick="Joomla.checkAll(this)" />
				</th>
				<th>
					<?php echo HTMLHelper::_('grid.sort',  'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
				</th>				
				<th class="center" width="10%">
					<?php echo HTMLHelper::_('grid.sort', 'JPUBLISHED', 'a.published', $listDirn, $listOrder); ?>
				</th>
				<th class="center" width="12%">
					<?php echo HTMLHelper::_('grid.sort',  'JGRID_HEADING_ORDERING', 'a.ordering', $listDirn, $listOrder); ?>
				</th>
				<th width="5%">
					<?php echo HTMLHelper::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
				</th>
			</tr>
		</thead>
			<tfoot>
				<tr>
					<td colspan="10">
						<?php echo $this->pagination->getListFooter(); ?>
					</td>
				</tr>
			</tfoot>
			<tbody>
			<?php foreach ($this->items as $i => $item) : ?>
				<tr class="row<?php echo $i % 2; ?>">
					<td>
						<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
					</td>
					<td>
						<a href="<?php echo Route::_('index.php?option=com_djtabs&task=group.edit&id='.(int) $item->id); ?>">
							<?php echo $this->escape($item->title); ?>
						</a>
					</td>
					<td class="center">
						<?php echo HTMLHelper::_('jgrid.published', $item->published, $i, 'groups.', true, 'cb'	); ?>
					</td>
					<td class="center">
						<span class="sortable-handler<?php echo !$saveOrder ? ' inactive tip-top hasTooltip" title="'.HTMLHelper::tooltipText('JORDERINGDISABLED') : ''; ?>">
							<span class="icon-menu"></span>
						</span>
						<?php if ($saveOrder) : ?>
							<input type="text" style="display:none" name="order[]" size="5" value="<?php echo $item->ordering; ?>" class="width-20 text-area-order" />
						<?php endif; ?>
					</td>
					<td>
						<?php echo $item->id; ?>
					</td>
				</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	
		<div>
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
			<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
			<?php echo HTMLHelper::_('form.token'); ?>
		</div>
	</div>
</div>
</form>
<?php echo DJTABSFOOTER; ?>
