<?php

/**
 * @copyright
 * @package    Easy Joomla Backup Pro - EJB for Joomla! 5
 * @author     Viktor Vogel <admin@kubik-rubik.de>
 * @version    5.1.0.0-PRO - 2024-07-28
 * @link       https://kubik-rubik.de/ejb-easy-joomla-backup
 *
 * @license    GNU/GPL
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace KubikRubik\Component\EasyJoomlaBackup\Administrator\Field;

defined('_JEXEC') || die('Restricted access');

use Exception;
use Joomla\CMS\{Form\FormField, Factory, HTML\HTMLHelper, Language\Text};

use function defined;

/**
 * Form Field class for Kubik-Rubik Joomla! Extensions.
 * Provides a custom title and description field.
 *
 * @since 5.0.0.0-PRO
 */
class KrTitleField extends FormField
{
    /**
     * @var string $type
     * @since 5.0.0.0-PRO
     */
    protected $type = 'krTitle';

    /**
     * Returns the label with the title and description, and adds required CSS classes and instructions.
     *
     * @return string
     * @throws Exception
     * @since 5.0.0.0-PRO
     */
    protected function getLabel(): string
    {
        static $executeOnce = false;

        if (empty($executeOnce)) {
            HTMLHelper::_('jquery.framework');
            $document = Factory::getApplication()->getDocument();

            $fieldsets = $this->form->getFieldsets();

            foreach ($fieldsets as $fieldset) {
                $scriptDeclaration = 'jQuery(function($){$("fieldset#fieldset-' . $fieldset->name . ' .control-label:has(.clr)").addClass("krtitle");});';

                if (empty($this->group)) {
                    $scriptDeclaration .= 'jQuery(function($){$("fieldset#' . $fieldset->name . ' .control-label:has(.clr)").addClass("krtitle");});';
                }

                $document->addScriptDeclaration($scriptDeclaration);
                $document->addStyleDeclaration('fieldset#fieldset-' . $fieldset->name . ' .control-label.krtitle, fieldset#' . $fieldset->name . ' .control-label.krtitle {width: 100%;} fieldset#fieldset-' . $fieldset->name . ' .control-label, fieldset#' . $fieldset->name . ' .control-label {width: 26em;} fieldset#fieldset-' . $fieldset->name . ' label, fieldset#' . $fieldset->name . ' label {width: 26em;}');
            }

            $document->addScriptDeclaration('jQuery(function($){$(".control-group:has(.krtitle-hidden)").remove();});');
            $document->addStyleDeclaration('div.krtitle-title {padding: 5px 5px 5px 0; font-size: 16px; font-weight: bold;} div.krtitle-title.sub {font-size: 14px;}');

            $executeOnce = true;
        }

        $filterDonationCode = (string)$this->element['filter'];

        if ($filterDonationCode === 'donation') {
            $fieldValueSession = Factory::getApplication()->getSession()->get('field_value', '', 'krdonationcodecheck');

            if ($fieldValueSession === 1) {
                return '<div class="krtitle-hidden"></div>';
            }
        }

        $label = '<div class="clr"></div>';

        if ($this->element['label']) {
            $classSub = '';

            if (isset($this->element['titleType'])) {
                $classSub = (string)$this->element['titleType'];
            }

            $label .= '<div class="krtitle-title ' . $classSub . '">' . Text::_((string)$this->element['label']) . '</div>';
        } else {
            $label .= parent::getLabel();
        }

        return $label;
    }

    /**
     * Don't use an input field.
     *
     * @return string
     * @since 5.0.0.0-PRO
     */
    protected function getInput(): string
    {
        return '';
    }
}
