<?php

/**
 * @copyright
 * @package    EJB PRO - Easy Joomla Backup PRO for Joomla! 5
 * @author     Viktor Vogel <admin@kubik-rubik.de>
 * @version    5.1.0.0-PRO - 2024-07-28
 * @link       https://kubik-rubik.de/ejb-easy-joomla-backup
 *
 * @license    GNU/GPL
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace KubikRubik\Component\EasyJoomlaBackup\Administrator\View\Backups;

defined('_JEXEC') || die('Restricted access');

use Exception;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\{Factory, Language\Text, Toolbar\ToolbarHelper};
use KubikRubik\Component\EasyJoomlaBackup\Administrator\Helper\EasyJoomlaBackupHelper;

use function defined;

/**
 * Class HtmlView
 *
 * @version 5.0.0.1-PRO
 * @since   5.0.0.0-PRO
 */
class HtmlView extends BaseHtmlView
{
    /**
     * @var string $dbType
     * @since 5.0.0.0-PRO
     */
    protected string $dbType;

    /**
     * @var bool $downloadAllowed
     * @since 5.0.0.0-PRO
     */
    protected bool $downloadAllowed;

    /**
     * @var array $items
     * @since 5.0.0.0-PRO
     */
    protected array $items;

    /**
     * @var object $pagination
     * @since 5.0.0.0-PRO
     */
    protected object $pagination;

    /**
     * @var array $pluginCronjobState
     * @since 5.0.0.0-PRO
     */
    protected array $pluginCronjobState;

    /**
     * @var array $pluginCliState
     * @since 5.0.0.0-PRO
     */
    protected array $pluginCliState;

    /**
     * @var string $sessionHandler
     * @since 5.0.0.0-PRO
     */
    protected string $sessionHandler;

    /**
     * @var object $state
     * @since 5.0.0.0-PRO
     */
    protected object $state;

    /**
     * @var array $uploadAllowed
     * @since 5.0.0.0-PRO
     */
    protected array $uploadAllowed;

    /**
     * @var array $uploadStatus
     * @since 5.0.0.0-PRO
     */
    protected array $uploadStatus;

    /**
     * @var bool $backupStorageLocationWritable
     * @since 5.0.0.0-PRO
     */
    protected bool $backupStorageLocationWritable;

    /**
     * @param null|string $tpl
     *
     * @return void
     * @throws Exception
     * @since 5.0.0.0-PRO
     */
    public function display($tpl = null): void
    {
        ToolbarHelper::title(Text::_('COM_EASYJOOMLABACKUP') . ' - ' . Text::_('COM_EASYJOOMLABACKUP_SUBMENU_ENTRIES'), 'cube');

        if (Factory::getApplication()->getIdentity()->authorise('easyjoomlabackup.fullbackup', 'com_easyjoomlabackup')) {
            ToolbarHelper::custom('fullbackup', 'new', 'new', Text::_('COM_EASYJOOMLABACKUP_FULLBACKUP'), false);
        }

        if (Factory::getApplication()->getIdentity()->authorise('easyjoomlabackup.databasebackup', 'com_easyjoomlabackup')) {
            ToolbarHelper::custom('databasebackup', 'new', 'new', Text::_('COM_EASYJOOMLABACKUP_DATABASEBACKUP'), false);
        }

        if (Factory::getApplication()->getIdentity()->authorise('easyjoomlabackup.filebackup', 'com_easyjoomlabackup')) {
            ToolbarHelper::custom('filebackup', 'new', 'new', Text::_('COM_EASYJOOMLABACKUP_FILEBACKUP'), false);
        }

        if (Factory::getApplication()->getIdentity()->authorise('easyjoomlabackup.discover', 'com_easyjoomlabackup')) {
            ToolbarHelper::custom('discover', 'refresh', 'refresh', Text::_('COM_EASYJOOMLABACKUP_DISCOVER'), false);
        }

        if (Factory::getApplication()->getIdentity()->authorise('core.delete', 'com_easyjoomlabackup')) {
            ToolbarHelper::deleteList();
        }

        if (Factory::getApplication()->getIdentity()->authorise('core.admin', 'com_easyjoomlabackup')) {
            ToolbarHelper::preferences('com_easyjoomlabackup', '500');
        }

        $this->items = $this->get('Data');
        $this->pagination = $this->get('Pagination');
        $this->state = $this->get('State');
        $this->pluginCronjobState = $this->get('PluginCronjobStatus');
        $this->pluginCliState = $this->get('PluginCliStatus');
        $this->downloadAllowed = Factory::getApplication()->getIdentity()->authorise('easyjoomlabackup.download', 'com_easyjoomlabackup');
        $this->uploadAllowed = EasyJoomlaBackupHelper::isUploadAllowed();
        $this->uploadStatus = EasyJoomlaBackupHelper::getUploadStatus();
        $this->dbType = Factory::getApplication()->get('dbtype');
        $this->sessionHandler = Factory::getApplication()->get('session_handler');
        $this->backupStorageLocationWritable = EasyJoomlaBackupHelper::isBackupStorageLocationWritable();

        Factory::getApplication()->getDocument()->addStyleSheet('components/com_easyjoomlabackup/src/Assets/Css/easyjoomlabackup.min.css');
        EasyJoomlaBackupHelper::showMessages();

        parent::display($tpl);
    }
}
