<?php

/**
 * @copyright
 * @package    Easy Joomla Backup Pro - EJB for Joomla! 5
 * @author     Viktor Vogel <admin@kubik-rubik.de>
 * @version    5.1.0.0-PRO - 2024-07-28
 * @link       https://kubik-rubik.de/ejb-easy-joomla-backup
 *
 * @license    GNU/GPL
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
defined('_JEXEC') || die('Restricted access');

use Joomla\CMS\{Language\Text, Session\Session, Factory};

?>
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="span12">
                <div class="progress">
                    <div id="backupProgress" class="progress-bar progress-bar-striped progress-bar-animated bg-info" role="progressbar" style="" aria-valuenow="" aria-valuemin="0" aria-valuemax="100"></div>
                    <div id="backupProgressQueue" class="progress-bar progress-bar-striped progress-bar-animated bg-info" role="progressbar" style="width: 100%; opacity: 0.4;"></div>
                </div>
                <div id="backupFileInformation">
                    <span id="backupLastFile"><?php echo Text::_('COM_EASYJOOMLABACKUP_BACKUPMODAL_INITIALISE'); ?></span>
                </div>
            </div>
        </div>
    </div>
<?php
$linkAjax = 'index.php?option=com_easyjoomlabackup&controller=Create&task=' . $this->backupTask . '&format=json&' . Session::getFormToken() . '=1';
$js = "!function(a){a(function(){let e=a('#backupProgress'),o=a('#backupProgressQueue'),n=a('#backupLastFile'),s=document.title;a('#create-backup-modal').on('shown.bs.modal',function(){t()}).on('hidden',function(){e.width('0%'),o.width('100%'),e.removeClass('bg-danger').addClass('bg-info')});var t=function(d){let c='" . $linkAjax . "&comment='+a('#comment').val()+'&password='+(a('#password').val()??'');void 0!==d&&(c+='&hash='+d),a.getJSON(c).done(function(d){d.success?(e.width(d.data.percent+'%'),o.width(100-d.data.percent+'%'),n.html(d.data.message),document.title=d.data.percent+'% - '+s,d.data.finished?(e.removeClass('bg-info').addClass('bg-success'),n.html('" . Text::_('COM_EASYJOOMLABACKUP_BACKUPMODAL_BACKUPDONE') . "'),location.href='index.php?option=com_easyjoomlabackup'):t(d.data.hash)):(console.log(JSON.stringify(d.data)),e.removeClass('bg-info').addClass('bg-danger'),a('#create-backup-modal').modal('hide'),location.href='index.php?option=com_easyjoomlabackup')}).fail(function(o,n,s){console.log(JSON.stringify(o)),e.removeClass('bg-info').addClass('bg-danger'),a('#create-backup-modal').modal('hide'),location.href='index.php?option=com_easyjoomlabackup'})}})}(jQuery);";
Factory::getApplication()->getDocument()->addScriptDeclaration($js);
