<?php
namespace JExtstore\Component\Gdpr\Administrator\Controller;
/**
 *
 * @package GDPR::CONFIG::administrator::components::com_gdpr
 * @subpackage controllers
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html 
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use JExtstore\Component\Gdpr\Administrator\Framework\Controller as GdprController;
use JExtstore\Component\Gdpr\Administrator\Framework\Helpers\Config as GdprConfigFile;

/**
 * Config controller concrete implementation
 *
 * @package GDPR::CPANEL::administrator::components::com_gdpr
 * @subpackage controllers
 * @since 1.6
 */
class ConfigController extends GdprController {

	/**
	 * Show configuration
	 * @access public
	 * @return void
	 */
	public function display($cachable = false, $urlparams = false) {
		parent::display($cachable);
	}

	/**
	 * Save config entity
	 * @access public
	 * @return bool
	 */
	public function saveEntity(): bool {
		$model = $this->getModel();
		$option = $this->option;
		
		// Access check
		if (!$this->allowConfigSave ( $option )) {
			$this->setRedirect ( "index.php?option=$option&task=config.display", Text::_ ( 'COM_GDPR_ERROR_ALERT_NOACCESS' ), 'notice' );
			return false;
		}
		
		if(!$model->storeEntity()) {
			// Model set exceptions for something gone wrong, so enqueue exceptions and levels on application object then set redirect and exit
			$modelException = $model->getException(null, false);
			$this->app->enqueueMessage($modelException->getMessage(), $modelException->getExceptionLevel());
			$this->setRedirect ( "index.php?option=$option&task=config.display", Text::_('COM_GDPR_ERROR_SAVING_PARAMS'));
			return false;
		}
		$this->setRedirect( "index.php?option=$option&task=config.display", Text::_('COM_GDPR_SAVED_PARAMS'));
		
		return true;
	}

	/**
	 * Reset all consents for #__user_profiles table to request a new privacy policy update greement
	 * @access public
	 * @return void
	 */
	public function resetConsents() {
		$model = $this->getModel();
		$option = $this->option;
	
		// Access check
		if (!$this->allowConfigSave ( $option )) {
			$this->setRedirect ( "index.php?option=$option&task=config.display", Text::_ ( 'COM_GDPR_ERROR_ALERT_NOACCESS' ), 'notice' );
			return false;
		}
	
		// Evaluate the yearly reset
		$yearlyReset = $this->task == 'resetYearlyConsents' ? true : false;
		
		if(!$model->resetAllConsents($yearlyReset)) {
			// Model set exceptions for something gone wrong, so enqueue exceptions and levels on application object then set redirect and exit
			$modelException = $model->getException(null, false);
			$this->app->enqueueMessage($modelException->getMessage(), $modelException->getExceptionLevel());
			$this->setRedirect ( "index.php?option=$option&task=config.display", Text::_('COM_GDPR_ERROR_RESET_CONSENTS'));
			return false;
		}
		$this->setRedirect( "index.php?option=$option&task=config.display", Text::_('COM_GDPR_SUCCESS_RESET_CONSENTS'));
	}
	
	/**
	 * Export sources as db table entities
	 *
	 * @access public
	 * @return void
	 */
	public function exportConfig() {
		$option = $this->option;
		// Access check
		if (! $this->allowEdit ( $option )) {
			$this->setRedirect ( 'index.php?option=com_gdpr&task=config.display', Text::_ ( 'COM_GDPR_ERROR_ALERT_NOACCESS' ), 'notice' );
			return false;
		}
	
		// Get the file manager instance with db connector dependency injection
		$filesManager = new GdprConfigFile ( Factory::getContainer()->get('DatabaseDriver'), $this->app );

		$cParams = ComponentHelper::getParams('com_gdpr');
		if($cParams->get('export_configuration_mode', 'full') == 'full') {
			$filesManagerExportResult = $filesManager->export ();
		} else {
			$filesManagerExportResult = $filesManager->exportPartial ();
		}

		if (! $filesManagerExportResult) {
			// Model set exceptions for something gone wrong, so enqueue exceptions and levels on application object then set redirect and exit
			$filesManagerException = $filesManager->getError ( null, false );
			$this->app->enqueueMessage ( $filesManagerException->getMessage (), $filesManagerException->getExceptionLevel () );
			$this->setRedirect ( "index.php?option=$option&task=config.display", Text::_ ( 'COM_GDPR_ERROR_CONFIG_EXPORT' ) );
			return false;
		}
	
		$this->setRedirect ( "index.php?option=$option&task=config.display", Text::_ ( 'COM_GDPR_SUCCESS_CONFIG_EXPORT' ) );
	}
	
	/**
	 * Import sources as db table entities
	 *
	 * @access public
	 * @return void
	 */
	public function importConfig() {
		$option = $this->option;
		// Access check
		if (! $this->allowEdit ( $option )) {
			$this->setRedirect ( 'index.php?option=com_gdpr&task=config.display', Text::_ ( 'COM_GDPR_ERROR_ALERT_NOACCESS' ), 'notice' );
			return false;
		}
	
		// Get the file manager instance with db connector dependency injection
		$filesManager = new GdprConfigFile ( Factory::getContainer()->get('DatabaseDriver'), $this->app );
	
		$cParams = ComponentHelper::getParams('com_gdpr');
		if($cParams->get('export_configuration_mode', 'full') == 'full') {
			$filesManagerImportResult = $filesManager->import ();
		} else {
			$filesManagerImportResult = $filesManager->importPartial ();
		}
		
		if (! $filesManagerImportResult) {
			// Model set exceptions for something gone wrong, so enqueue exceptions and levels on application object then set redirect and exit
			$filesManagerException = $filesManager->getError ( null, false );
			$this->app->enqueueMessage ( $filesManagerException->getMessage (), $filesManagerException->getExceptionLevel () );
			$this->setRedirect ( "index.php?option=$option&task=config.display", Text::_ ( 'COM_GDPR_ERROR_CONFIG_IMPORT' ) );
			return false;
		}
	
		$this->setRedirect ( "index.php?option=$option&task=config.display", Text::_ ( 'COM_GDPR_SUCCESS_CONFIG_IMPORT' ) );
	}
	
	/**
	 * Constructor.
	 *
	 * @access protected
	 * @param
	 *       	 array An optional associative array of configuration settings.
	 *       	 Recognized key values include 'name', 'default_task',
	 *       	 'model_path', and
	 *       	 'view_path' (this list is not meant to be comprehensive).
	 * @since 1.5
	 */
	public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null) {
		parent::__construct($config, $factory, $app, $input);
		
		// Register Extra tasks
		$this->registerTask ( 'resetYearlyConsents', 'resetConsents' );
	}
}