<?php
namespace JExtstore\Component\Gdpr\Administrator\Field;
/**  
 * @package GDPR::components::com_gdpr
 * @subpackage framework 
 * @subpackage html
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html   
 */ 
defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;

/**
 * Form Field for ACL Groups
 * @package GDPR::components::com_gdpr
 * @subpackage framework 
 * @subpackage html
 * @since 2.0
 */
class CookieauditField extends FormField {
	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 * @since  11.1
	 */
	protected $type = 'Cookieaudit';

	/**
	 * Method to get the field input markup.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   11.1
	 */
	protected function getInput() {
		$uri = Uri::root();
		$hostDomain = trim(preg_replace('/http(s?):\/\//i', '', $uri), '/');
		$domain = 'https://cookiepedia.co.uk/website/' . urlencode($hostDomain);
		$html = '<a class="badge bg-success badge-audit hasPopover" data-bs-content="' . Text::_('COM_GDPR_COOKIEPEDIA_AUDIT_DESC') .'" href="' . $domain . '" target="_blank">' . Text::_('COM_GDPR_COOKIEPEDIA_AUDIT') .'</a>';

		return $html;
	}
	
}
