<?php
namespace JExtstore\Component\Gdpr\Administrator\View\Cpanel;
/**
 *
 * @package GDPR::CPANEL::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage cpanel
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html 
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use JExtstore\Component\Gdpr\Administrator\Framework\View as GdprView;
use JExtstore\Component\Gdpr\Administrator\Framework\Helpers\Toolbars as ToolbarHelper;

/**
 * CPanel view
 *
 * @package GDPR::CPANEL::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage cpanel
 * @since 1.6
 */
class HtmlView extends GdprView {
	// Template view variables
	protected $componentParams;
	protected $icons;
	protected $updatesData;
	protected $infodata;
	protected $currentVersion;
	protected $showUserNotes;
	protected $items;
	protected $nullDate;
	
	/**
	 * Renderizza l'iconset del cpanel
	 *
	 * @param $link string
	 * @param $image string
	 * @access private
	 * @return string
	 */
	private function getIcon($link, $image, $text, $target = '', $title = null, $class = 'icons') {
		$app = Factory::getApplication ();
		$lang = $app->getLanguage ();
		$option = $this->option;
		?>
		<div class="<?php echo $class;?>" style="float:<?php echo ($lang->isRTL()) ? 'right' : 'left'; ?>;">
			<div class="icon" aria-hidden="true">
				<a <?php echo $title . $class;?> <?php echo $target;?>
					href="<?php echo $link; ?>">
					<div class="task <?php echo $image;?>"></div> <span class="task"><?php echo $text; ?></span>
				</a>
			</div>
		</div>
<?php
		}
		
	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addDisplayToolbar() {
		$doc = $this->app->getDocument();
		ToolbarHelper::title( Text::_('COM_GDPR_CPANEL_TOOLBAR' ), 'gdpr' );
		ToolbarHelper::custom('cpanel.display', 'home', 'home', 'COM_GDPR_CPANEL', false);
	}
	
	/**
	 * Effettua il rendering del pannello di controllo
	 * @access public
	 * @return void
	 */
	public function display($tpl = null) {
		$doc = $this->app->getDocument ();
		$this->loadJQuery($doc);
		$this->loadBootstrap($doc);
		$doc->getWebAssetManager()->registerAndUseStyle('gdpr.cpanel', 'administrator/components/com_gdpr/css/cpanel.css');
		$doc->getWebAssetManager()->registerAndUseStyle('gdpr.audit', 'administrator/components/com_gdpr/css/audit.css');
		
		$doc->getWebAssetManager()->registerAndUseScript ( 'gdpr.chart', 'administrator/components/com_gdpr/js/chart.js', [], [], ['jquery']);
		$doc->getWebAssetManager()->registerAndUseScript ( 'gdpr.cpanel', 'administrator/components/com_gdpr/js/cpanel.js', [], [], ['jquery', 'gdpr.boostrap-interface', 'gdpr.chart']);
		$doc->getWebAssetManager()->registerAndUseScript ( 'gdpr.audit', 'administrator/components/com_gdpr/js/audit.js', [], [], ['jquery']);
		
		// Inject js translations
		$translations = array(
				'COM_GDPR_START_CHART',
				'COM_GDPR_NEW_CHART',
				'COM_GDPR_DELETED_CHART',
				'COM_GDPR_BREACHED_CHART',
				'COM_GDPR_END_CHART',
				'COM_GDPR_CATEGORY1_CHART',
				'COM_GDPR_CATEGORY2_CHART',
				'COM_GDPR_CATEGORY3_CHART',
				'COM_GDPR_CATEGORY4_CHART',
				'COM_GDPR_AUDIT_DIALOG_TITLE',
				'COM_GDPR_AUDIT_CURRENT_TARGET_LINK',
				'COM_GDPR_AUDIT_TARGET_LINK',
				'COM_GDPR_AUDIT_CHOOSE_TARGET_LINK',
				'COM_GDPR_AUDIT_CURRENT_STATUS_IDLE',
				'COM_GDPR_AUDIT_CURRENT_STATUS_RUNNING',
				'COM_GDPR_AUDIT_CURRENT_STATUS_COMPLETED',
				'COM_GDPR_AUDIT_START',
				'COM_GDPR_AUDIT_FOOTER',
				'COM_GDPR_WIZARD_START',
				'COM_GDPR_WIZARD_DESCRIPTION',
				'COM_GDPR_WIZARD_STARTED',
				'COM_GDPR_WIZARD_RESULTS_COOKIE',
				'COM_GDPR_WIZARD_RESULTS_DOMAINS',
				'COM_GDPR_WIZARD_COOKIE_RESULTS_NAME',
				'COM_GDPR_WIZARD_DOMAIN_RESULTS_NAME',
				'COM_GDPR_WIZARD_RESULTS_CATEGORY',
				'COM_GDPR_WIZARD_NULL_RESPONSEDATA',
				'COM_GDPR_WIZARD_ERROR_AUTOCONFIGURE',
				'COM_GDPR_WIZARD_RESULTS_NOCOOKIES',
				'COM_GDPR_WIZARD_RESULTS_NODOMAINS',
				'COM_GDPR_AUDIT_RESULTS_COOKIE',
				'COM_GDPR_AUDIT_RESULTS_COOKIE_NAME',
				'COM_GDPR_AUDIT_RESULTS_COOKIE_VALUE',
				'COM_GDPR_AUDIT_SEARCH_COOKIE',
				'COM_GDPR_AUDIT_SEARCH_DOMAIN',
				'COM_GDPR_AUDIT_RESULTS_DOMAINS',
				'COM_GDPR_AUDIT_AUDIT_ERROR',
				'COM_GDPR_WIZARD_ERROR_HTTP',
				'COM_GDPR_AUDIT_STARTED',
				'COM_GDPR_AUDIT_RESULTS_NOCOOKIES',
				'COM_GDPR_AUDIT_RESULTS_NODOMAINS'
		);
		$this->injectJsTranslations($translations, $doc);
		$this->componentParams = $this->getModel()->getComponentParams();
		
		// Buffer delle icons
		ob_start ();
		$this->getIcon ( 'index.php?option=com_gdpr&task=logs.display', 'icon-list', Text::_ ( 'COM_GDPR_LOGS' ) );
		$this->getIcon ( 'index.php?option=com_gdpr&task=consents.display', 'icon-database', Text::_ ( 'COM_GDPR_LOGS_CONSENTS' ) );
		$this->getIcon ( 'index.php?option=com_gdpr&task=cookie.display', 'icon-cube', Text::_ ( 'COM_GDPR_LOGS_COOKIE_CONSENTS' ) );
		
		if ($this->user->authorise('core.edit', 'com_gdpr')) {
			switch($this->componentParams->get('consent_registry_format', 'csv')) {
				case 'csv':
					$this->getIcon ( 'index.php?option=com_gdpr&task=cpanel.exportCsvRegistry', 'icon-printer', Text::_ ( 'COM_GDPR_EXPORT_REGISTRY' ) );
					break;
					
				case 'xls':
					$this->getIcon ( 'index.php?option=com_gdpr&task=cpanel.exportXlsRegistry', 'icon-printer', Text::_ ( 'COM_GDPR_EXPORT_REGISTRY' ) );
					break;
			}
		}

		$this->getIcon ( 'index.php?option=com_gdpr&task=checkbox.display', 'icon-checkbox', Text::_ ( 'COM_GDPR_DYNAMIC_CHECKBOX' ) );
		$this->getIcon ( 'index.php?option=com_gdpr&task=cookiedescriptions.display', 'icon-pencil', Text::_ ( 'COM_GDPR_COOKIE_DESCRIPTIONS' ) );
		$this->getIcon ( 'index.php?option=com_gdpr&task=users.display', 'icon-users', Text::_ ( 'COM_GDPR_USERS' ) );
		
		// Access check.
		if ($this->user->authorise('core.admin', 'com_gdpr')) {
			$this->getIcon ( 'index.php?option=com_gdpr&task=record.display', 'icon-calendar-2', Text::_ ( 'COM_GDPR_RECORD' ) );
			$this->getIcon ( 'index.php?option=com_gdpr&task=config.display#_cookieconsent', 'icon-checkmark', Text::_ ( 'COM_GDPR_CONFIGURATION_COOKIECONSENT' ) );
			$this->getIcon ( 'index.php?option=com_gdpr&task=config.display#_userprofile', 'icon-user', Text::_ ( 'COM_GDPR_USERPROFILE' ) );
			$this->getIcon ( 'index.php?option=com_gdpr&task=config.display#_privacycheckbox', 'icon-checkbox', Text::_ ( 'COM_GDPR_CHECKBOX' ) );
			$this->getIcon ( 'index.php?option=com_gdpr&task=config.display#_permissions', 'icon-lock', Text::_ ( 'COM_GDPR_PERMISSIONS' ) );
			$this->getIcon ( 'index.php?option=com_gdpr&task=config.display', 'icon-cog', Text::_ ( 'COM_GDPR_CONFIG' ) );
		}
		
		$this->getIcon ( 'javascript:void(0);', 'icon-cogs', Text::_ ( 'COM_GDPR_WEBSITE_AUDIT' ), '', null, 'icons audit' );
		$this->getIcon ( 'https://storejextensions.org/gdpr_documentation.html', 'icon-help', Text::_ ( 'COM_GDPR_HELP' ) );
		
		$contents = ob_get_clean ();
		
		$infoData = $this->getModel()->getData();
		$doc->getWebAssetManager()->addInlineScript('var gdprChartData = ' . json_encode($infoData) . ';');
		$doc->getWebAssetManager()->addInlineScript('var gdprBaseAuditHome = "' . Uri::root ( false ) . '";');
		
		// Get uri instance avoidng subdomains already included in the routing chunks
		$uriInstance = Uri::getInstance();
		$baseDomainLiveSite = rtrim($uriInstance->getHost(), '/');
		$doc->getWebAssetManager()->addInlineScript('var gdprBaseDomain = "' . $baseDomainLiveSite . '";');
		
		// Assign reference variables
		$this->icons = $contents;
		$this->updatesData = $this->getModel()->getUpdates($this->get('httpclient'));
		$this->infodata = $infoData;
		$this->currentVersion = strval(simplexml_load_file(JPATH_COMPONENT_ADMINISTRATOR . '/gdpr.xml')->version);
		
		// Add toolbar
		$this->addDisplayToolbar();
		
		// Output del template
		parent::display ();
	}
	
	/**
	 * Effettua l'output view del file in attachment al browser
	 *
	 * @access public
	 * @param array $data
	 * @return void
	 */
	public function sendCSVRegistry($data) {
		$componentConfig = $this->getModel()->getComponentParams();
		$delimiter = $componentConfig->get('csv_delimiter', ';');
		$enclosure = $componentConfig->get('csv_enclosure', '"');
		$userNotes = $componentConfig->get('log_usernote_privacypolicy', 1);
		$nullDate = $this->getModel()->getDbo()->getNullDate();
		
		// Clean dirty buffer
		ob_end_clean();
		// Open buffer
		ob_start();
		// Open out stream
		$outstream = fopen("php://output", "w");
		// Funzione di scrittura nell'output stream
		function __outputCSV(&$vals, $key, $userData) {
			$vals = array_map(function ($v, $k) use ($userData) {
					if($k === 'registerDate') {
						$v = (!$v || $v == $userData[4] || in_array($v, array('0000-00-00 00:00:00', '1000-01-01 00:00:00'))) ? Text::_('COM_GDPR_NEVER') : HTMLHelper::_('date', $v, Text::_('COM_GDPR_DATE_FORMAT_FILTER_DATETIME'));
					}
				
					switch($v) {
						case null:
							$v = Text::_('COM_GDPR_LOGS_NA');
							break;
						case '1':
							$v = Text::_('COM_GDPR_LOGS_ACCEPTED');
							break;
						case '0':
							$v = Text::_('COM_GDPR_LOGS_NOT_ACCEPTED');
							break;
					}
					
					if($k === 'body' && !$userData[5]) {
						$v = Text::_('COM_GDPR_LOGS_NA');
					}
				return $v;
			}, $vals, array_keys($vals));
					
			fputcsv($userData[0], $vals, $userData[1], $userData[2]); // add parameters if you want
		}
	
		// Echo delle intestazioni
		$headerFields = array(
				Text::_('COM_GDPR_LOGS_NAME'),
				Text::_('COM_GDPR_LOGS_USERNAME'),
				Text::_('COM_GDPR_LOGS_EMAIL'),
				Text::_('COM_GDPR_LOGS_REGISTERDATE'),
				Text::_('COM_GDPR_LOGS_PRIVACYPOLICY_STATUS'),
				Text::_('COM_GDPR_LOGS_PRIVACYPOLICY_DESCRIPTION')
		);
		__outputCSV($headerFields, null, array($outstream, $delimiter, $enclosure, true, $nullDate, $userNotes));
	
		// Output di tutti i records
		array_walk($data, "\JExtstore\Component\Gdpr\Administrator\View\Cpanel\__outputCSV", array($outstream, $delimiter, $enclosure, false, $nullDate, $userNotes));
		fclose($outstream);
		// Recupero output buffer content
		$contents = ob_get_clean();
		$size = strlen($contents);
	
		// Set file date
		$dataExport = HTMLHelper::_('date', time (), 'Y-m-d_H:i:s');
	
		// Recupero output buffer content
		$exportedFileName = 'user_consent_registry_' . $dataExport . '.csv';
	
		header ( 'Pragma: public' );
		header ( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
		header ( 'Expires: ' . gmdate ( 'D, d M Y H:i:s' ) . ' GMT' );
		header ( 'Content-Disposition: attachment; filename="' . $exportedFileName . '"' );
		header ( 'Content-Type: text/plain' );
		header ( "Content-Length: " . $size );
		echo $contents;
			
		exit ();
	}
	
	/**
	 * Effettua l'output view del file in attachment al browser
	 *
	 * @access public
	 * @param array $data
	 * @return void
	 */
	public function sendXLSRegistry() {
		// Get main records
		$rows = $this->getModel()->exportRegistry('objects_array');

		if(!$rows) {
			$this->app->enqueueMessage(Text::_('COM_GDPR_NODATA_EXPORT'), 'notice');
			$this->app->redirect('index.php?option=' . $this->option . '&task=cpanel.display');
			return false;
		}

		$componentConfig = $this->getModel()->getComponentParams();
		$userNotes = $componentConfig->get('log_usernote_privacypolicy', 1);
		$nullDate = $this->getModel()->getDbo()->getNullDate();
		
		$this->option = $this->getModel ()->getState ( 'option' );
		$this->nullDate = $nullDate;
		$this->showUserNotes = $userNotes;
		$this->items = $rows;
	
		//Creazione buffer output
		ob_start ();
		// Parent construction and view display
		parent::display ( 'xls' );
		$bufferContent = ob_get_contents ();
		ob_end_clean ();
	
		// Set file date
		$dataExport = HTMLHelper::_('date', time (), 'Y-m-d_H:i:s');
	
		// Recupero output buffer content
		$exportedFileName = 'account_consent_registry_' . $dataExport . '.xls';
		header ( 'Pragma: public' );
		header ( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
		header ( 'Expires: ' . gmdate ( 'D, d M Y H:i:s' ) . ' GMT' );
		header ( 'Content-Disposition: attachment; filename="' . $exportedFileName . '"' );
		header ( 'Content-Type: application/vnd.ms-excel' );
	
		echo $bufferContent;
	
		exit ();
	}
}
?>