<?php 
/** 
 * @package GDPR::COOKIEDESCRIPTIONS::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage cookiedescriptions
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<table class="headerlist">
		<tr>
			<td class="left">
				<div class="mb-2">
					<div class="input-group">
						<span class="input-group-text" aria-label="<?php echo Text::_('COM_GDPR_FILTER_RECORD');?>"><span class="icon-filter" aria-hidden="true"></span> <?php echo Text::_('COM_GDPR_FILTER_RECORD' ); ?>:</span>
						<input type="text" name="search" id="search" value="<?php echo htmlspecialchars($this->searchword, ENT_COMPAT, 'UTF-8');?>" class="text_area"/>
					</div>
					<button class="btn btn-primary btn-sm" onclick="this.form.submit();"><?php echo Text::_('COM_GDPR_GO' ); ?></button>
					<button class="btn btn-primary btn-sm" onclick="document.getElementById('search').value='';this.form.submit();"><?php echo Text::_('COM_GDPR_RESET' ); ?></button>
				</div>
			</td>
			<td class="right d-flex justify-content-end">
				<div class="input-group d-none d-md-flex flex-end">
					<span class="input-group-text" aria-label="<?php echo Text::_('COM_GDPR_STATE');?>"><span class="icon-filter" aria-hidden="true"></span> <?php echo Text::_('COM_GDPR_STATE' ); ?></span>
					<label class="visually-hidden" for="filter_state"><?php echo Text::_('JLIB_HTML_SELECT_STATE');?></label>
					<?php
						echo $this->lists['state'];
						echo $this->lists['categories'];
					?>
					<label class="visually-hidden" for="limit"><?php echo Text::_('JGLOBAL_LIST_LIMIT');?></label>
					<?php
						echo $this->pagination->getLimitBox();
					?>
				</div>
			</td>
		</tr>
	</table>

	<table id="adminList" class="adminlist table table-striped table-hover">
	<thead>
		<tr>
			<th width="1%">
				<?php echo Text::_('COM_GDPR_NUM' ); ?>
			</th>
			<th width="1%">
				<input type="checkbox" name="checkall-toggle" value="" class="form-check-input" onclick="Joomla.checkAll(this)" />
			</th>
			<th width="15%">
				<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_COOKIEDESCRIPTIONS_COOKIE', 's.cookie', @$this->orders['order_Dir'], @$this->orders['order'], 'cookiedescriptions.display' ); ?>
			</th>
			<th width="8%" class="d-none d-md-table-cell">
				<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_COOKIEDESCRIPTIONS_CATEGORY', 's.category', @$this->orders['order_Dir'], @$this->orders['order'], 'cookiedescriptions.display' ); ?>
			</th>
			<th class="d-none d-md-table-cell">
				<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_COOKIEDESCRIPTIONS_DESCRIPTIONHTML', 's.descriptionhtml', @$this->orders['order_Dir'], @$this->orders['order'], 'cookiedescriptions.display' ); ?>
			</th>
			<th class="d-none d-md-table-cell">
				<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_COOKIEDESCRIPTIONS_EXPIRATION', 's.expiration', @$this->orders['order_Dir'], @$this->orders['order'], 'cookiedescriptions.display' ); ?>
			</th>
			<th width="8%" class="d-none d-md-table-cell">
				<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_COOKIEDESCRIPTIONS_ALIAS', 's.alias', @$this->orders['order_Dir'], @$this->orders['order'], 'cookiedescriptions.display' ); ?>
			</th>
			<th width="5%">
				<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_PUBLISHED', 's.published', @$this->orders['order_Dir'], @$this->orders['order'], 'cookiedescriptions.display' ); ?>
			</th>
			<th  width="5%">
				<?php echo HTMLHelper::_('grid.sort', 'COM_GDPR_ID', 's.id', @$this->orders['order_Dir'], @$this->orders['order'], 'cookiedescriptions.display' ); ?>
			</th>
		</tr>
	</thead>
	<?php
	$canCheckin = $this->user->authorise('core.manage', 'com_checkin');
	$k = 0;
	for ($i=0, $n=count( $this->items ); $i < $n; $i++) {
		$row = $this->items[$i];
		$link =  'index.php?option=com_gdpr&task=cookiedescriptions.editEntity&cid[]='. $row->id ;
		$taskPublishing	= !isset($row->published) || !$row->published ? 'cookiedescriptions.publish' : 'cookiedescriptions.unpublish';
		$altPublishing 	= !isset($row->published) || !$row->published ? Text::_( 'COM_GDPR_PUBLISH' ) : Text::_( 'COM_GDPR_UNPUBLISH' );
		
		$checked = null;
		// Access check.
		if($this->user->authorise('core.edit', 'com_gdpr')) {
			$checked = $row->checked_out && $row->checked_out != $this->user->id ?
			HTMLHelper::_('jgrid.checkedout', $i, Factory::getContainer()->get(\Joomla\CMS\User\UserFactoryInterface::class)->loadUserById($row->checked_out)->name, $row->checked_out_time, 'cookiedescriptions.', $canCheckin) . '<input type="checkbox" style="display:none" data-enabled="false" id="cb' . $i . '" name="cid[]" value="' . $row->id . '"/>' :
			HTMLHelper::_('grid.id', $i, $row->id);
		} else {
			$checked = '<input type="checkbox" style="display:none" data-enabled="false" id="cb' . $i . '" name="cid[]" value="' . $row->id . '"/>';
		}
		
		if($this->user->authorise('core.edit.state', 'com_gdpr')) {
			$published = '<a href="index.php?option=com_gdpr&task=' . $taskPublishing . '&cid[]=' . $row->id . '">';
			$published .= !isset($row->published) || $row->published == 0 ? '<img alt="' . $altPublishing . '" src="' . Uri::base(true) . '/components/com_gdpr/images/icon-16-publish_x.png" width="16" height="16" border="0"/>' :
																			'<img alt="' . $altPublishing . '" src="' . Uri::base(true) . '/components/com_gdpr/images/icon-16-tick.png" width="16" height="16" border="0"/>';
			$published .= '</a>';
		} else {
			$published = '<img alt="' . $altPublishing . '" src="' . Uri::base(true) . '/components/com_gdpr/images/icon-16-tick.png" width="16" height="16" border="0"/>';
		}
		
		?>
		<tr>
			<td>
				<?php echo $this->pagination->getRowOffset($i); ?>
			</td>
			<td>
				<?php echo $checked; ?>
			</td>
		
			<td>
				<?php
				if ( ($row->checked_out && ( $row->checked_out != $this->user->id)) || !$this->user->authorise('core.edit', 'com_gdpr') ) {
					echo $row->name;
				} else {
					?>
					<a href="<?php echo $link; ?>" title="<?php echo Text::_('COM_GDPR_EDIT_RECORD' ); ?>">
						<span class="icon-pencil" aria-hidden="true"></span>
						<?php echo $row->cookie; ?>
					</a>
					<?php
				}
				?>
			</td>
			<td class="d-none d-md-table-cell">
				<span class="badge bg-info"><?php echo Text::_('COM_GDPR_CONFIGURATION_COOKIECATEGORIES_CAT' . $row->category); ?></span>
			</td>
			<td class="d-none d-md-table-cell">
				<?php echo strip_tags($row->descriptionhtml); ?>
			</td>
			<td class="d-none d-md-table-cell">
				<span class="badge bg-warning"><?php echo $row->expiration; ?></span>
			</td>
			<td class="d-none d-md-table-cell">
				<?php echo $row->alias; ?>
			</td>
			<td>
				<?php echo $published;?>
			</td>
			<td>
				<?php echo $row->id; ?>
			</td>
		</tr>
		<?php
	}
	?>
	<tfoot>
		<td colspan="100%">
			<?php echo $this->pagination->getListFooter(); ?>
		</td>
	</tfoot>
	</table>

	<input type="hidden" name="option" value="<?php echo $this->option;?>" />
	<input type="hidden" name="task" value="cookiedescriptions.display" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo @$this->orders['order'];?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo @$this->orders['order_Dir'];?>" />
</form>