<?php
/**
 * @Securitycheckpro component
 * @copyright Copyright (c) 2011 - Jose A. Luque / Securitycheck Extensions
 * @license   GNU General Public License version 3, or later
 */

namespace SecuritycheckExtensions\Component\SecuritycheckPro\Administrator\View\Malwarescan;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use SecuritycheckExtensions\Component\SecuritycheckPro\Administrator\Model\BaseModel;

/**
 * Main Admin View
 */
class HtmlView extends BaseHtmlView {
    
    /**
     * Display the main view
     *
     * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
     * @return  void
     */
    function display($tpl = null) {
		  
		ToolBarHelper::title(Text::_('Securitycheck Pro').' | ' .Text::_('COM_SECURITYCHECKPRO_MALWARESCAN'), 'securitycheckpro');
		
		// Load css and js
		$this->document->getWebAssetManager()
		  ->usePreset('com_securitycheckpro.common')		 
		  ->useScript('com_securitycheckpro.Malwarescan');

        // Obtenemos los datos del modelo
        $model = $this->getModel();
        $this->last_check_malwarescan = $model->loadStack("malwarescan_resume", "last_check_malwarescan");
        $this->files_scanned_malwarescan = $model->loadStack("malwarescan_resume", "files_scanned_malwarescan");
        $this->suspicious_files = $model->loadStack("malwarescan_resume", "suspicious_files");
		$this->time_taken = $model->loadStack("malwarescan_resume", "time_taken");
        $this->log_filename = $model->get_log_filename("filemalware_log", true);

        $task_ended = $model->get_campo_filemanager("estado_malwarescan");

        // Establecemos el tamao mximo de memoria que el script puede consumir
        $params = ComponentHelper::getParams('com_securitycheckpro');
        $this->deep_scan_status = $params->get('deep_scan', 0);
        $this->online_submission_type = $params->get('online_submission_type', 'Hashes');
        $this->timeline = $params->get('timeline', 7);
		$this->file_manager_include_exceptions_in_database = $params->get('file_manager_include_exceptions_in_database', 0);
		// Consultamos dónde han de ir los 'checkboxes'
		$this->checkbox_position = $params->get('checkbox_position','0');

        if ($this->deep_scan_status) {
            $this->deep_scan_status = Text::_('COM_SECURITYCHECKPRO_PLUGIN_ENABLED');
        } else
        {
            $this->deep_scan_status = Text::_('COM_SECURITYCHECKPRO_PLUGIN_DISABLED');
        }

        // Información para la barra de navegación
        $this->logs_pending = $model->LogsPending();
        $this->trackactions_plugin_exists = $model->PluginStatus(8);
       
        // Malwarescanstatus

        // Filtro por tipo de extensión
        $this->state= $model->getState();
        $malwarescan_search = $this->state->get('filter.malwarescan_search');
        $filter_malwarescan_status = $this->state->get('filter.malwarescan_status');

        // Establecemos el valor del filtro 'malwarescan_status' a cero para que muestre sólo los archivos sospechosos
        if ($filter_malwarescan_status == '') {
            $this->state->set('filter.malwarescan_status', 0);
        }

        $this->items = $model->loadStack("malwarescan", "malwarescan");
        $this->online_checked_files = $model->get_campo_filemanager("online_checked_files");
        $this->online_checked_hashes = $model->get_campo_filemanager("online_checked_hashes");
        $this->show_all = $this->state->get('showall', 0);
        $this->database_error = $model->get_campo_filemanager("estado_malwarescan");

        // Consultamos los valores de configuración
        $params = ComponentHelper::getParams('com_securitycheckpro');
        $this->opswat_key = $params->get('opswat_key', '');
        $this->online_submission_type = $params->get('online_submission_type', 'Hashes');
        
        if (!empty( $this->items)) {
            $this->pagination = $model->getPagination();            
            ToolBarHelper::custom('manage_online_logs', 'folder-2 ', 'folder-2 ', 'COM_SECURITYCHECKPRO_MANAGE_ONLINE_LOGS', false);
            ToolBarHelper::custom('csv_export_malware', 'out-2', 'out-2', 'COM_SECURITYCHECKPRO_EXPORT_INFO_CSV', false);
            ToolBarHelper::custom('delete_file', 'delete', 'delete', 'COM_SECURITYCHECKPRO_DELETE');
            ToolBarHelper::custom('view_file', 'eye-open', 'eye-open', 'COM_SECURITYCHECKPRO_VIEW_FILE');
        }
		
		$mainframe = Factory::getApplication();
		$jinput = $mainframe->input;
        
        $view = $jinput->get('view', null);
        $task = $jinput->get('task', null);
              
        // Inicializamos la variable de estado clean_tmp_dir_state                
        $mainframe->setUserState("clean_tmp_dir_state", Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_ENDED'));
		
		// Var for the javascript file
		$contenido = $mainframe->getUserState('contenido', "vacio"); 
                                        
        if ($view == "malwarescan") {             
            if ($task != "view_file") {                 
                 // Si la tarea es distinta a "view_file" inicializamos la variable de estado 'contenido'
                 $mainframe->setUserState('contenido', "vacio");
            }
        }
		
		// Also comes common data from SecuritycheckExtensions\Component\SecuritycheckPro\Administrator\Controller\DisplayController
		
		// Pass parameters to the cpanel.js script using Joomla's script options API
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.activetaskText', addslashes(Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_ACTIVE_TASK')));
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.taskfailureText', addslashes(Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_TASK_FAILURE')));
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.repairviewlogheader', '<div class="alert alert-info" role="alert">' . addslashes(Text::_('COM_SECURITYCHECKPRO_REPAIR_VIEW_LOG_HEADER')) . '</div>');
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.processcompletedText', addslashes(Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_PROCESS_COMPLETED')));		
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.end', '<span class="badge bg-success">' . addslashes(Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_ENDED')) . '</span>');
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.inprogress', '<span class="badge bg-info">' . addslashes(Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_IN_PROGRESS')) . '</span>');
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.error', '<span class="badge bg-danger">' . addslashes(Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_ERROR')) . '</span>');
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.updatingstats', addslashes(Text::_('COM_SECURITYCHECKPRO_UPDATING_STATS')) . '<br/><br/><div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>');
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.urltoredirect', Route::_('index.php?option=com_securitycheckpro&controller=filemanager&view=malwarescan&'. Session::getFormToken() .'=1', false));
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.failureText', addslashes(Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_FAILURE')));
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.warningText', addslashes(Text::_('COM_SECURITYCHECKPRO_WARNING_MESSAGE')));
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.errorbutton', '<button class="btn btn-primary" type="button" onclick="window.location.reload();">' . addslashes(Text::_('COM_SECURITYCHECKPRO_FILEMANAGER_REFRESH_BUTTON')) . '</button>');       
		$this->document->addScriptOptions('securitycheckpro.Malwarescan.contenido', $contenido);

        parent::display($tpl); 
    }


}