<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Administrator\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Object\CMSObject;

/**
 * Weblink Logos Pro helper.
 */
class WeblinkLogosProHelper
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string	The name of the active view.
	 * @since   1.6
	 */
// 	public static function addSubmenu($vName = 'info')
// 	{
// 		JHtmlSidebar::addEntry(
// 			Text::_('COM_WEBLINKLOGOSPRO_SUBMENU_INFO'),
// 			'index.php?option=com_weblinklogospro&amp;view=info',
// 			$vName == 'info'
// 		);

// 		if (\JFolder::exists(JPATH_ROOT.'/components/com_weblinks') && ComponentHelper::isEnabled('com_weblinks')) {

// 			$lang = Factory::getLanguage();
// 			$lang->load('com_weblinks', JPATH_ADMINISTRATOR);

//  			JHtmlSidebar::addEntry('<hr>', '');

// 			JHtmlSidebar::addEntry(Text::_('COM_WEBLINKS_SUBMENU_WEBLINKS'), 'index.php?option=com_weblinks&view=weblinks', $vName == 'weblinks');
// 			JHtmlSidebar::addEntry(Text::_('COM_WEBLINKS_SUBMENU_CATEGORIES'), 'index.php?option=com_categories&extension=com_weblinks', $vName == 'categories');

// 			if (\JFolder::exists(JPATH_ADMINISTRATOR . '/components/com_fields') && ComponentHelper::isEnabled('com_fields') && ComponentHelper::getParams('com_weblinks')->get('custom_fields_enable', '0')) {

// 				JHtmlSidebar::addEntry(Text::_('JGLOBAL_FIELDS'), 'index.php?option=com_fields&context=com_weblinks.weblink');
// 				JHtmlSidebar::addEntry(Text::_('JGLOBAL_FIELD_GROUPS'), 'index.php?option=com_fields&view=groups&context=com_weblinks.weblink');
// 			}
// 		}
// 	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return    CMSObject
	 */
	public static function getActions($messageId = 0)
	{
		$user = Factory::getUser();
		$result = new CMSObject();

		if (empty($messageId)) {
			$assetName = 'com_weblinklogospro';
		} else {
			$assetName = 'com_weblinklogospro.message.'.(int) $messageId;
		}

		$actions = array(
			'core.admin', 'core.manage'
		);

		foreach ($actions as $action) {
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}

}
