<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\Language\Language;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\User;
use Joomla\Database\Exception\ExecutionFailureException;
use Joomla\Input\Input;

/**
 * Weblink form controller class
 */
class WeblinkController extends FormController
{
	public function __construct($config = array(), MVCFactoryInterface $factory = null, ?CMSApplication $app = null, ?Input $input = null, FormFactoryInterface $formFactory = null)
	{
		parent::__construct($config, $factory, $app, $input);

		$this->registerTask('apply', 'apply'); // does not catch the task without this
	}

	/**
	 * Method to check out an item for editing and redirect to the edit form.
	 *
	 * @return void
	 *
	 * @since    1.6
	 */
	public function edit($key = null, $urlVar = null)
	{
		$app = Factory::getApplication();

		// Do not cache the response to this, its a redirect, and mod_expires and google chrome browser bugs cache it forever!
		$app->allowCache(false);

		// Get the previous edit id (if any) and the current edit id
		$previousId = (int) $app->getUserState('com_weblinklogospro.edit.weblink.id');
		$editId = $app->input->getInt('id', 0);

		// Set the user id for the user to edit in the session
		$app->setUserState('com_weblinklogospro.edit.weblink.id', $editId);

		// Get the model
		$model = $this->getModel();

		// Check out the item
		if ($editId) {
			$model->checkout($editId);
		}

		// Check in the previous user
		if ($previousId) {
			$model->checkin($previousId);
		}

		// Redirect to the edit screen
		$this->setRedirect(Route::_('index.php?option=com_weblinklogospro&view=weblink' . $this->getRedirectToItemAppend($editId), false));
	
		return true;
	}

	/**
	 * Gets the URL arguments to append to an item redirect.
	 *
	 * @param   integer  $recordId  The primary key id for the item.
	 * @param   string   $urlVar    The name of the URL variable for the id.
	 *
	 * @return  string    The arguments to append to the redirect URL.
	 *
	 * @since   4.0.0
	 */
	protected function getRedirectToItemAppend($recordId = 0, $urlVar = 'id')
	{
		// Need to override the parent method completely.
		$tmpl = $this->input->get('tmpl');

		$append = '';

		// Setup redirect info.
		if ($tmpl)
		{
			$append .= '&tmpl=' . $tmpl;
		}

		$append .= '&layout=edit';

		$append .= '&' . $urlVar . '=' . (int) $recordId;

		$itemId = $this->input->getInt('Itemid');
		$return = $this->getReturnPage();
		$catId  = $this->input->getInt('catid');

		if ($itemId)
		{
			$append .= '&Itemid=' . $itemId;
		}

		if ($catId)
		{
			$append .= '&catid=' . $catId;
		}

		if ($return)
		{
			$append .= '&return=' . base64_encode($return);
		}

		return $append;
	}

	/**
	 * Get the return URL.
	 *
	 * If a "return" variable has been passed in the request
	 *
	 * @return  string    The return URL.
	 *
	 * @since   4.0.0
	 */
	protected function getReturnPage()
	{
		$return = $this->input->get('return', null, 'base64');

		if (empty($return) || !Uri::isInternal(base64_decode($return)))
		{
			return Uri::base();
		}

		return base64_decode($return);
	}

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  object  The model.
	 */
	public function getModel($name = 'Weblink', $prefix = 'Site', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

	/**
	 * Method to save weblink data and stay on the form
	 *
	 * @return void
	 *
	 * @throws \Exception
	 * @since  1.6
	 */
	public function apply($key = null, $urlVar = null)
	{
		// Check for request forgeries
		Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));

		// Initialise variables
		$app = Factory::getApplication();
		$model = $this->getModel('Weblink');

		// Get the data
		$data = $app->input->get('jform', array(), 'array');

		$form = $model->getForm();

		if (!$form) {
			throw new \Exception($model->getError(), 500);
		}

		// Validate the posted data
		$data = $model->validate($form, $data);

		// Check for errors.
		if ($data === false) {

			// Get the validation messages
			$errors = $model->getErrors();

			// Push up to three validation messages out to the user
			for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
				if ($errors[$i] instanceof \Exception) {
					$app->enqueueMessage($errors[$i]->getMessage(), 'warning');
				} else {
					$app->enqueueMessage($errors[$i], 'warning');
				}
			}

			$input = $app->input;
			$jform = $input->get('jform', array(), 'ARRAY');

			// Save the data in the session
			$app->setUserState('com_weblinklogospro.edit.weblink.data', $jform);

			// Redirect back to the edit screen
			$id = (int) $app->getUserState('com_weblinklogospro.edit.weblink.id');
			$this->setRedirect(Route::_('index.php?option=com_weblinklogospro&view=weblink&layout=edit&id=' . $id, false));

			$this->redirect();
		}

		// Attempt to save the data
		$return = $model->save($data);

		// Check for errors
		if ($return === false) {
			$this->setMessage(Text::sprintf('COM_WEBLINKLOGOSPRO_WEBLINK_SAVED_FAILED', $model->getError()), 'warning');
		} else {
			$this->setMessage(Text::_('COM_WEBLINKLOGOSPRO_WEBLINK_SAVED_SUCCESSFULLY'));
		}

		// Save the data in the session
		//$app->setUserState('com_weblinklogospro.edit.weblink.data', $data);

		$return_path = '';
		$return = $this->input->get('return', null, 'base64');
		if (null != $return) {
			$return_path = '&return=' . $return;
		}

		// Redirect back to the edit screen
		$id = (int) $app->getUserState('com_weblinklogospro.edit.weblink.id');
		$this->setRedirect(Route::_('index.php?option=com_weblinklogospro&view=weblink&layout=edit&id=' . $id . $return_path, false));
	}

	/**
	 * Method to save weblink data
	 *
	 * @return void
	 *
	 * @throws \Exception
	 * @since  1.6
	 */
	public function save($key = null, $urlVar = null)
	{
		// Check for request forgeries
		Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));

		// Initialise variables
		$app = Factory::getApplication();
		$model = $this->getModel('Weblink');

		// Get the data
		$data = $app->input->get('jform', array(), 'array');

		$form = $model->getForm();

		if (!$form) {
			throw new \Exception($model->getError(), 500);
		}

		// Validate the posted data
		$data = $model->validate($form, $data);

		// Check for errors.
		if ($data === false) {

			// Get the validation messages
			$errors = $model->getErrors();

			// Push up to three validation messages out to the user
			for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
				if ($errors[$i] instanceof \Exception) {
					$app->enqueueMessage($errors[$i]->getMessage(), 'warning');
				} else {
					$app->enqueueMessage($errors[$i], 'warning');
				}
			}

			$input = $app->input;
			$jform = $input->get('jform', array(), 'ARRAY');

			// Save the data in the session
			$app->setUserState('com_weblinklogospro.edit.weblink.data', $jform);

			// Redirect back to the edit screen
			$id = (int) $app->getUserState('com_weblinklogospro.edit.weblink.id');
			$this->setRedirect(Route::_('index.php?option=com_weblinklogospro&view=weblink&layout=edit&id=' . $id, false));

			$this->redirect();
		}

		// Attempt to save the data
		$return = $model->save($data);

		// Check for errors.
		if ($return === false) {
			// Save the data in the session
			$app->setUserState('com_weblinklogospro.edit.weblink.data', $data);

			// Redirect back to the edit screen
			$id = (int) $app->getUserState('com_weblinklogospro.edit.weblink.id');
			$this->setMessage(Text::sprintf('COM_WEBLINKLOGOSPRO_WEBLINK_SAVED_FAILED', $model->getError()), 'warning');
			$this->setRedirect(Route::_('index.php?option=com_weblinklogospro&view=weblink&layout=edit&id=' . $id, false));
		} else {

		    // send notification mail to administrators
		    $notify_admins = ComponentHelper::getParams('com_weblinklogospro')->get('mail_to_admin', '0');
		    if ($notify_admins != '0') {

		        $config = Factory::getConfig();
		        $user = Factory::getUser();

		        $emailSubject = Text::sprintf('COM_WEBLINKLOGOSPRO_EMAIL_WEBLINKEDITED_SUBJECT', $data['id'], $config->get('sitename'));
		        $emailBodyAdmin = Text::sprintf('COM_WEBLINKLOGOSPRO_EMAIL_WEBLINKEDITED_BODY', $user->name, $user->username, $data['title'], Uri::base());

		        // get all admin users
		        $db = Factory::getDbo();

		        $query = $db->getQuery(true);

		        $query->select($db->quoteName(array('id', 'name', 'email')));
		        $query->from($db->quoteName('#__users'));
		        $query->where($db->quoteName('sendEmail').' = 1');
		        $query->where($db->quoteName('block').' = 0');

		        $db->setQuery($query);

		        try {
		            $rows = $db->loadObjectList();
		        } catch (ExecutionFailureException $e) {
		            //$app->enqueueMessage(Text::_('COM_WEBLINKLOGOSPRO_WEBLINKEDITED_NOTIFICATION_EMAIL_FAILED'), 'warning');
		            $rows = array();
		        }

		        BaseDatabaseModel::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_messages/models', 'MessagesModel');
		        Table::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_messages/tables');
		        $messagemodel = BaseDatabaseModel::getInstance('Message', 'MessagesModel');

		        $privatemessage = array();
		        $privatemessage['subject'] = $emailSubject;
		        $privatemessage['message'] = $emailBodyAdmin;

		        foreach ($rows as $row) {
		            $receiver = User::getInstance($row->id);
		            $lang = Language::getInstance($receiver->getParam('admin_language', ComponentHelper::getParams('com_languages')->get('administrator')), $config->get('debug_lang'));

		            if ($notify_admins == '1') {
		                $return = Factory::getMailer()->sendMail($config->get('mailfrom'), $config->get('fromname'), $row->email, $emailSubject, $emailBodyAdmin);

		                if ($return !== true) {
		                    //$app->enqueueMessage(Text::_('COM_WEBLINKLOGOSPRO_WEBLINKEDITED_NOTIFICATION_EMAIL_FAILED'), 'warning');
		                }
		            } else {
		                $privatemessage['user_id_to'] = $row->id;
		                $messagemodel->save($privatemessage);
		            }
		        }
		    }

    		// Check in the profile
    		$model->checkin($return);

    		// Clear the profile id from the session
    		$app->setUserState('com_weblinklogospro.edit.weblink.id', null);

    		$this->setMessage(Text::_('COM_WEBLINKLOGOSPRO_WEBLINK_SAVED_SUCCESSFULLY'));

    		$return = $this->input->get('return', null, 'base64');
    		if ($return) {
    			$this->setRedirect(Route::_(base64_decode($return), false));
    		} else {
	    		// Redirect to the list screen
	    		$menu = Factory::getApplication()->getMenu();
	    		$item = $menu->getActive();
	    		$url  = (empty($item->link) ? 'index.php?option=com_weblinklogospro&view=weblinks' : $item->link);
	    		$this->setRedirect(Route::_($url, false));
    		}

    		// Flush the data from the session
    		$app->setUserState('com_weblinklogospro.edit.weblink.data', null);
		}
	}

	/**
	 * Method to abort current operation
	 *
	 * @return void
	 *
	 * @throws \Exception
	 */
	public function cancel($key = null)
	{
		$app = Factory::getApplication();

		// Get the current edit id
		$editId = (int) $app->getUserState('com_weblinklogospro.edit.weblink.id');

		// Get the model
		$model = $this->getModel('Weblink');

		// Check in the item
		if ($editId) {
			$model->checkin($editId);
		}

		$return = $this->input->get('return', null, 'base64');
		if ($return) {
			$this->setRedirect(Route::_(base64_decode($return), false));
		} else {
			$menu = Factory::getApplication()->getMenu();
			$item = $menu->getActive();
			$url  = (empty($item->link) ? 'index.php?option=com_weblinklogospro&view=weblinks' : $item->link);
			$this->setRedirect(Route::_($url, false));
		}
	}

	/**
	 * Method to remove data
	 *
	 * @return void
	 *
	 * @throws \Exception
     *
     * @since 1.6
	 */
	public function remove()
    {
        $app = Factory::getApplication();
        $model = $this->getModel('weblink');
        $pk = $app->input->getInt('id');

        // Attempt to save the data
        try {
            $return = $model->delete($pk);

            // Check in the profile
            $model->checkin($return);

            // Clear the profile id from the session
            $app->setUserState('com_weblinklogospro.edit.weblink.id', null);

            $menu = $app->getMenu();
            $item = $menu->getActive();
            $url = (empty($item->link) ? 'index.php?option=com_weblinklogospro&view=weblinks' : $item->link);

            // Redirect to the list screen
            $this->setMessage(Text::_('COM_WEBLINKLOGOSPRO_WEBLINK_DELETED_SUCCESSFULLY'));
            $this->setRedirect(Route::_($url, false));

            // Flush the data from the session
            $app->setUserState('com_weblinklogospro.edit.weblink.data', null);
        } catch (\Exception $e) {
            $errorType = ($e->getCode() == '404') ? 'error' : 'warning';
            $this->setMessage($e->getMessage(), $errorType);
            $this->setRedirect('index.php?option=com_weblinklogospro&view=weblinks');
        }
    }
}
