<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\View\Weblinks;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SYW\Component\WeblinkLogosPro\Site\Cache\WeblinksCSSFileCache;
use SYW\Component\WeblinkLogosPro\Site\Helper\Helper;
use SYW\Library\Fonts as SYWFonts;
use SYW\Library\Stylesheets as SYWStylesheets;
use SYW\Library\Utilities as SYWUtilities;

/**
 * View class for a list of weblinks
 */
class HtmlView extends BaseHtmlView
{
	protected $items;

	protected $pagination;

	protected $state;

	protected $params;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template name
	 *
	 * @return void
	 *
	 * @throws \Exception
	 */
	public function display($tpl = null)
	{
	    $app = Factory::getApplication();
	    $this->input = $app->input;
	    
	    $wam = $app->getDocument()->getWebAssetManager();

		$this->state = $this->get('State');
		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');
		$this->params = $app->getParams(); // view merged with config
		$this->view_params = $this->state->get('parameters.menu'); // view only
		$this->filterForm = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new \Exception(implode("\n", $errors));
		}

		$user = Factory::getUser();
		if (count($this->items) == 1 && !$user->authorise('core.create', 'com_weblinklogospro') && !$user->authorise('core.delete', 'com_weblinklogospro')) {
		    //foreach ($this->items as $item) {
		    //if ($user->id == $item->user_id) {
		    $app->redirect(Route::_('index.php?option=com_weblinklogospro&task=weblink.edit&id=' . $this->items[0]->id, false));
		    //}
		    //}
		}

		$this->extra_suffix = 'weblinks';
		if ($app->getMenu()->getActive()) {
		    $this->extra_suffix .= '_'.$app->getMenu()->getActive()->id;
		}
		
		$this->actions_style = $this->view_params->get('actions_style', 'dropdown');
		$this->actions_classes = trim($this->view_params->get('actions_classes', ''));

		$this->show_print = $this->view_params->get('print', 0);
		$this->print = $this->input->getBool('print', false);

		$this->show_search = $this->view_params->get('search', 1); // 1 for backward compatibility

		$this->limitstart_request_value = $this->input->getInt('limitstart', 0);

		//$listOrder  = $this->state->get('list.ordering');
		//$listDirn   = $this->state->get('list.direction');

		$this->order_request = '';
		$this->order_request_value = $this->input->getString('filter_order', '');
		if (!empty($this->order_request_value)) {
		    $this->order_request = '&filter_order='.$this->order_request_value;
		}
		$this->pagination->setAdditionalUrlParam('filter_order', $this->order_request_value);

		$this->dir_request = '';
		$this->dir_request_value = $this->input->getString('filter_order_Dir', '');
		if (!empty($this->dir_request_value)) {
		    $this->dir_request = '&filter_order_Dir='.$this->dir_request_value;
		}
		$this->pagination->setAdditionalUrlParam('filter_order_Dir', $this->dir_request_value);

		$this->search_request = '';
		$this->search_request_value = $this->input->getString('filter-search', '');
		if (!empty($this->search_request_value)) {
		    $this->search_request = '&filter-search='.$this->search_request_value;
		}
		$this->pagination->setAdditionalUrlParam('filter-search', $this->search_request_value);

		$this->limits = Helper::getLimitsForBox();

		// advanced settings

		$this->bootstrap_version = $this->params->get('bootstrap_version', 'joomla');
		$this->load_bootstrap = false;
		if ($this->bootstrap_version === 'joomla') {
		    $this->bootstrap_version = 5; //version_compare(JVERSION, '4.0.0', 'lt') ? 2 : 5;
		    $this->load_bootstrap = true;
		} else {
			$this->bootstrap_version = intval($this->bootstrap_version);
		}

		$this->show_errors = Helper::isShowErrors($this->params);

		$this->remove_whitespaces = Helper::isRemoveWhitespaces($this->params);

		$this->clear_header_files_cache = Helper::IsClearHeaderCache($this->params);

		$this->load_chosen_script = $this->params->get('load_chosen_script', 0);

// 		if ($this->params->get('load_icon_font', 1)) {
 		    SYWFonts::loadIconFont();
// 		}

		$this->isMobile = SYWUtilities::isMobile();

        // load the CSS needed for accessibility
		if ($this->bootstrap_version == 0 || $this->bootstrap_version == 2) {
		    SYWStylesheets::loadAccessibilityVisibilityStyles();
		}

		// caching the stylesheet

		$cache_css = new WeblinksCSSFileCache('com_weblinklogospro', $this->params);

		$result = $cache_css->cache('style_'.$this->extra_suffix.'.css', $this->clear_header_files_cache);

		if ($result) {
			//$doc->addStyleSheet(Uri::base(true).'/media/cache/com_weblinklogospro/style_'.$this->extra_suffix.'.css');
			$wam->registerAndUseStyle('wlp.style_' . $this->extra_suffix, $cache_css->getCachePath() . '/style_' . $this->extra_suffix . '.css');
		}

		$this->_prepareDocument();

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 *
	 * @return void
	 *
	 * @throws \Exception
	 */
	protected function _prepareDocument()
	{
		$app = Factory::getApplication();
		$menus = $app->getMenu();
		$title = null;

		// Because the application sets a default page title, we need to get it from the menu item itself
		$menu = $menus->getActive();

		$this->page_heading = '';
		if ($this->params->get('show_page_heading')) {
		    if (trim($this->params->get('page_heading')) != '') {
		        $this->page_heading = trim($this->params->get('page_heading'));
		    } else {
		        $this->page_heading = trim($this->params->get('page_title'));
		    }
		}

		$title = $this->params->get('page_title', '');

		if (empty($title))
		{
			$title = $app->get('sitename');
		}
		elseif ($app->get('sitename_pagetitles', 0) == 1)
		{
			$title = Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
		}
		elseif ($app->get('sitename_pagetitles', 0) == 2)
		{
			$title = Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
		}

		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
	}

	/**
	 * Check if state is set
	 *
	 * @param   mixed  $state  State
	 *
	 * @return bool
	 */
	public function getState($state)
	{
		return isset($this->state->{$state}) ? $this->state->{$state} : false;
	}
}
