<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Installer\InstallerAdapter;

/**
 * Script file of the Weblink Logos Pro component
 */
class Mod_WeblinkLogoInstallerScript
{
    /**
     * A list of files to be deleted
     */
    protected $deleteFiles = array();
    
    /**
     * A list of folders to be deleted
     */
    protected $deleteFolders = array();
    
    /**
     * Extension script constructor
     */
    public function __construct($parent)
    {
        Factory::getLanguage()->load('pkg_weblinklogospro.sys');
    }
    
    /**
     * Called before any type of action
     *
     * @param string $action Which action is happening (install|uninstall|discover_install|update)
     * @param InstallerAdapter $installer The class calling this method
     *
     * @return boolean True on success
     */
    public function preflight($action, $installer)
    {
        return true;
    }
    
    /**
     * method to install the component
     *
     * @return boolean True on success
     */
    public function install($installer)
    {
	    Factory::getApplication()->enqueueMessage(Text::sprintf('PKG_WEBLINKLOGOSPRO_INSTALLED', Text::_('PKG_WEBLINKLOGOSPRO_MODULE_WEBLINKLOGO')), 'message');
    }
    
    /**
     * method to uninstall the component
     *
     * @return void
     */
    public function uninstall($installer)
    {
	    //Factory::getApplication()->enqueueMessage(Text::sprintf('PKG_WEBLINKLOGOSPRO_UNINSTALLED', Text::_('PKG_WEBLINKLOGOSPRO_MODULE_WEBLINKLOGO')), 'message');
    }
    
    /**
     * method to update the component
     *
     * @return boolean True on success
     */
    public function update($installer)
    {
	    Factory::getApplication()->enqueueMessage(Text::sprintf('PKG_WEBLINKLOGOSPRO_UPDATED', Text::_('PKG_WEBLINKLOGOSPRO_MODULE_WEBLINKLOGO')), 'message');
    }
    
    /**
     * Called after any type of action
     *
     * @param string $action Which action is happening (install|uninstall|discover_install|update)
     * @param InstallerAdapter $installer The object responsible for running this script
     *
     * @return boolean True on success
     */
    public function postflight($action, $installer)
    {
        if ($action === 'uninstall') {
            return true;
        }
        
        if ($action === 'update') {

            // remove files
            
            $this->deleteFiles[] = '/media/mod_weblinklogos/css/common_styles-min.css';
        }
        
        $this->removeFiles();
        
        return true;
    }
    
    /**
     * Remove the files and folders in the given array from
     */
    private function removeFiles()
    {
        if (!empty($this->deleteFiles))
        {
            foreach ($this->deleteFiles as $file)
            {
                if (file_exists(JPATH_ROOT . $file) && !File::delete(JPATH_ROOT . $file))
                {
                    echo Text::sprintf('JLIB_INSTALLER_ERROR_FILE_FOLDER', $file) . '<br>';
                }
            }
        }
        
        if (!empty($this->deleteFolders))
        {
            foreach ($this->deleteFolders as $folder)
            {
                if (Folder::exists(JPATH_ROOT . $folder) && !Folder::delete(JPATH_ROOT . $folder))
                {
                    echo Text::sprintf('JLIB_INSTALLER_ERROR_FILE_FOLDER', $folder) . '<br>';
                }
            }
        }
    }

}
